<#ibiztemplate>
TARGET=PSCODELIST
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${item.getPSSystemModule().codeName?lower_case}.codelist;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.util.StringUtils;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import ${pub.getPKGCodeName()}.ibizutil.domain.CodeList;
import ${pub.getPKGCodeName()}.ibizutil.domain.CodeItem;

<#comment>定义实体服务</#comment>
<#if item.getCodeListType() == "DYNAMIC" && item.getPSDataEntity()??>
import ${pub.getPKGCodeName()}.${item.getPSDataEntity().getPSSystemModule().codeName?lower_case}.service.${item.getPSDataEntity().codeName}Service;
</#if>
/**
 * 代码表[${item.name}]
 */
@Component("${sys.codeName}_${item.codeName}CodeList")
public class ${item.codeName}CodeList extends ${pub.getPKGCodeName()}.ibizutil.domain.CodeListBase{
    @PostConstruct
	protected void init()
	{
	}
<#if item.getCodeListType() == "DYNAMIC" && item.getPSDataEntity()??>
	@Autowired
	private ${item.getPSDataEntity().codeName}Service ${item.getPSDataEntity().codeName?lower_case}Service;

	protected ${item.getPSDataEntity().codeName}Service get${item.getPSDataEntity().codeName}Service(){
		return ${item.getPSDataEntity().codeName?lower_case}Service;
	}
</#if>
<#assign bTree=false>
	@Override
	public void initCodeList() <#if item.getCodeListType() == "DYNAMIC" && item.getPSDataEntity()??></#if> {
		CodeList codeList = new CodeList();
		codeList.setSrfkey("${sys.codeName}_${item.codeName}");
		List<CodeItem> codeItemList = new ArrayList<CodeItem>();
<#if item.getCodeListType() == "STATIC" && item.getAllPSCodeItems()??>
	<#list item.getAllPSCodeItems() as codeitem>
		CodeItem item${codeitem_index?c} = new CodeItem();
		<#comment>判断是否为数值代码项</#comment>
		<#if item.isCodeItemValueNumber()==true>
		item${codeitem_index?c}.setValue(${srfjavastring(codeitem.getValue())});
		<#else>
		item${codeitem_index?c}.setValue("${srfjavastring(codeitem.getValue())}");
		</#if>
		item${codeitem_index?c}.setId("${srfjavastring(codeitem.getValue())}");
		item${codeitem_index?c}.setText("${srfjavastring(codeitem.getText())}");
		item${codeitem_index?c}.setLabel("${srfjavastring(codeitem.getText())}");
		<#if codeitem.getParentCodeItem()??>
			<#assign bTree=true>
		item${codeitem_index?c}.setParentValue("${codeitem.getParentCodeItem().getValue()}");
		</#if>
		<#if codeitem.isDisableSelect()>
		item${codeitem_index?c}.setDisabled(true);
		</#if>
		codeItemList.add(item${codeitem_index?c});
		codeList.getCodeItemModelMap().put("${srfjavastring(codeitem.getValue())}",item${codeitem_index?c});
	</#list>
	<#if bTree==true>
        List<CodeItem> codeItemTreeList = new ArrayList<CodeItem>();
        codeItemTreeList = getTrees(codeItemList, "");
		codeList.setItems(codeItemTreeList.toArray(new CodeItem[codeItemTreeList.size()]));
	<#else>
		codeList.setItems(codeItemList.toArray(new CodeItem[codeItemList.size()]));
	</#if>
</#if>
<#if item.getCodeListType() == "DYNAMIC" && item.getPSDataEntity()??>
	<#assign filtername>${pub.getPKGCodeName()}.${item.getPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.dto.${item.getPSDataEntity().getCodeName()}SearchFilter</#assign>
	<#assign entityname>${pub.getPKGCodeName()}.${item.getPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.domain.${item.getPSDataEntity().getCodeName()}</#assign>
	${filtername} searchFilter = new ${filtername}();
	<#if ((item.getFetchCondition())!"") != "">
			searchFilter.setCustomCond("${item.getFetchCondition()}");
	</#if>
	<#if item.getMinorSortPSDEField()??>
		String strSortField = "${item.getMinorSortPSDEField().getCodeName()}";
		<#if item.getMinorSortDir()?? && item.getMinorSortDir() == "DESC">
		searchFilter.getSelectCond().orderBy(true, false, strSortField);
		<#else>
		searchFilter.getSelectCond().orderBy(true, true, strSortField);
		</#if>
	</#if>
	<#if item.getPSDEDataSet().getCodeName()??>
        List<${entityname}> pageResult = this.${item.getPSDataEntity().codeName?lower_case}Service.list${item.getPSDEDataSet().getCodeName()}(searchFilter);
	<#else>
		List<${entityname}> pageResult = this.${item.getPSDataEntity().codeName?lower_case}Service.listDefault(searchFilter);
	</#if>
		for(${entityname} entity : pageResult) {
			CodeItem item = new CodeItem();
	<#if item.getValuePSDEField().getCodeName()??>
			String strId = entity.get${item.getValuePSDEField().getCodeName()?lower_case?cap_first}();
			item.setValue(strId);
			item.setId(strId);
	</#if>
	<#if item.getTextPSDEField().getCodeName()??>
			String strText = entity.get${item.getTextPSDEField().getCodeName()?lower_case?cap_first}();
			item.setText(strText);
			item.setLabel(strText);
	</#if>
	<#if item.getPValuePSDEField()??>
		<#assign bTree=true>
			String strParentId = entity.get${item.getPValuePSDEField().getCodeName()?lower_case?cap_first}();
			item.setParentValue(strParentId);
	</#if>
	<#if item.getDisablePSDEField()??>
			String strDisabled = String.valueOf(entity.get${item.getDisablePSDEField().getCodeName()?lower_case?cap_first}());
			if("1".equalsIgnoreCase(strDisabled)){
				item.setDisabled(true);
			}
	</#if>
			codeItemList.add(item);
			codeList.getCodeItemModelMap().put(strId,item);
		}
	<#if bTree==true>
        List<CodeItem> codeItemTreeList = new ArrayList<CodeItem>();
        codeItemTreeList = getTrees(codeItemList, "");
		codeList.setItems(codeItemTreeList.toArray(new CodeItem[codeItemTreeList.size()]));
	<#else>
		codeList.setItems(codeItemList.toArray(new CodeItem[codeItemList.size()]));
	</#if>
</#if>
        this.setCodeList(codeList);
    }
}